<%--
 If an HMC session is forcibly disconnected, for example due to being idle or
 because the connection with the browser was lost, and the user then attempts
 to access the HMC, the launchDefunctCleanup.jsp is run.  It opens a new
 browser window and loads this JSP into that window to close any HMC browser
 windows and display an error message.  If the HMC session to which they were
 connected still exists, and is disconnected, the user will be offered a link
 that can be used to attempt to reconnect to that session.

 This JSP can also be launched directly by "pushing" a script to the task
 controller.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<fmt:timeZone value="${userTimeZone}">
<html>
<head>
   <hmc:title><fmt:message key="defunctCleanupTitle"/></hmc:title>
   <link href="/skin/HMCskin.css" rel="stylesheet" type="text/css"/>
   <meta http-equiv="Cache-Control" content="no-cache">
</head>
<body>
<span class="cont1">

<script type="text/javascript">
   <c:if test="${not empty reconnectURI}">
      function followReconnectURL() {
         <%--
         // We displayed this panel in a small window, but now that we're going
         // to initiate reconnect processing from here, the window needs to be
         // bigger.  It must accomodate the login prompt and other
         // pre-main-window tasks that might need to run, such as selecting
         // from disconnected sessions or changing an expired password.
         --%>
         try {
            desiredWidth = 640; desiredHeight = 480;

            if (desiredWidth > screen.availWidth - 20)
               desiredWidth = screen.availWidth - 20;

            if (desiredHeight > screen.availHeight - 20)
               desiredHeight = screen.availHeight - 20;

            desiredX = (screen.availWidth  - desiredWidth)  / 2;
            desiredY = (screen.availHeight - desiredHeight) / 2;

            window.moveTo(desiredX, desiredY);
            window.resizeTo(desiredWidth, desiredHeight);
         } catch (e) {
            // Ignore exceptions
         }

         window.location.replace("<c:out value='${reconnectURI}' escapeXml='false'/>");
      }
   </c:if>

   var windowNames = [
    <c:forEach var="name" varStatus="loopStatus" items="${windowNames}">
       "<c:out value='${name}'/>" <c:if test="${!loopStatus.last}">,</c:if>
    </c:forEach>
       ];

   for (var i=0; i<windowNames.length; ++i) {
      try {
         taskwin = window.open("", windowNames[i]);
         taskwin.onunload = "";
         taskwin.onbeforeunload = "";
         taskwin.hmcWindowIsClosed = "Y";
         taskwin.close();
      } catch (e) {
         // Ignore exceptions
      }
   }
</script>

<p>
<fmt:message key="defunctCleanupIntro">
   <%--
     -- We do the following instead of simply
     --    <fmt:param value="${disconnectTime}"/>
     -- in order to make sure the date is formatted with the correct time zone
     --%>
   <fmt:param>
      <fmt:formatDate value="${disconnectTime}" type="date"/>
   </fmt:param>
   <fmt:param>
      <fmt:formatDate value="${disconnectTime}" type="time"/>
   </fmt:param>
</fmt:message>
</p>

<p style="font-weight:bold; color:red">
   <fmt:message key="${disconnectReason}"/>
</p>

<c:if test="${not empty reconnectURI}">
   <p>
   <fmt:message key="defunctCleanupReconnectMessage"/>
   </p>
   <p>
   <a class="lnk1" href="javascript:followReconnectURL()">
      <fmt:message key="defunctCleanupReconnectLink"/>
   </a>
   </p>
</c:if>

<c:if test="${empty reconnectURI}">
   <p>
   <fmt:message key="defunctCleanupWrapup"/>
   </p>
</c:if>

<form>
   <input type="button" onclick="window.close()" value="<fmt:message key='closeButtonLabel'/>"
          class="b1" onmouseout="className='b1'"
          onmouseover="className='b2'" />
</form>
</span>
</body>
</html>
</fmt:timeZone>
</fmt:bundle>
